<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="refno"></xsl:param>
<xsl:param name="pinno"></xsl:param>
<xsl:param name="blockno"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:template match="/">
	<html>
		<head>
			<title>
				Waveform View
			</title>
			<link rel="stylesheet" type="text/css" href="../js/mnlstyle.css"/>
		</head>
		<body>
			<xsl:if test="$pinno != ''">
				<xsl:apply-templates select="//ROW[@REF=$refno and @PIN=$pinno and @BLK=$blockno]/V[@WL != '' and @MODE=$mode]"/>
			</xsl:if> 
			<xsl:if test="$pinno = ''">
				<xsl:apply-templates select="//ROW[@REF=$refno and @BLK=$blockno]/V[@WL != '']"/>
			</xsl:if> 
		</body>
	</html>
</xsl:template>

<xsl:template match="//V">
	<xsl:if test="../V[@WL != '']">
		<table style="display:inline;">
			<tr align="center" valign="middle">
				<th nowrap="nowrap">
					<xsl:value-of select="../@BLK"/>:
					<xsl:text> </xsl:text>
					<xsl:value-of select="../@REF"/> - Pin
					<xsl:text> </xsl:text>
					<xsl:value-of select="../@PIN"/>
					<xsl:text> [</xsl:text>
					<xsl:value-of select="@MODE"/>
					<xsl:text>]</xsl:text>
				</th>
			</tr>
			<tr align="center" valign="middle">
				<td>
					<table border="1"><tr><td>
					<xsl:if test="contains(@WL,'.svgz')">
						<embed border="0" align="middle" width="164" height="124" vspace="2" hspace="2">
							<xsl:attribute name="src">../wf/<xsl:value-of select="@WL"/></xsl:attribute>
						</embed>
					</xsl:if>
					<xsl:if test="contains(@WL,'.png') or contains(@WL,'.gif') or contains(@WL,'.bmp')">
						<img border="0" align="middle" width="160" height="120" vspace="2" hspace="2">
							<xsl:attribute name="src">../wf/<xsl:value-of select="@WL"/></xsl:attribute>
						</img>
					</xsl:if>
					</td></tr></table>
				</td>
			</tr>
			<tr><td><br/></td></tr>
		</table>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
